/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.mayor;

import java.util.Locale;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public enum ReputationStatus {
    STRANGER(0.0f, TextFormatting.RED),
    NEUTRAL(3.0f, TextFormatting.YELLOW),
    FRIENDLY(10.0f, TextFormatting.GREEN),
    LOYAL(25.0f, TextFormatting.BLUE),
    HERO(50.0f, TextFormatting.DARK_PURPLE);

    private final int tierLevel = this.ordinal() + 1;
    private final float sinceReputation;
    private final IFormattableTextComponent statusDescriptor;
    private final TextFormatting color;

    private ReputationStatus(float sinceReputation, TextFormatting color) {
        this.sinceReputation = sinceReputation;
        this.color = color;
        this.statusDescriptor = this.generateLocalizedDescriptor();
    }

    public static ReputationStatus getStatus(float reputation) {
        ReputationStatus status = STRANGER;
        ReputationStatus[] values = ReputationStatus.values();
        for (int i = 1; i < values.length; ++i) {
            ReputationStatus reputationStatus = values[i];
            if (!(reputation >= reputationStatus.sinceReputation)) break;
            status = reputationStatus;
        }
        return status;
    }

    public int getBaseTier() {
        return this.tierLevel;
    }

    public IFormattableTextComponent getStatusDescriptor() {
        return this.statusDescriptor;
    }

    private IFormattableTextComponent generateLocalizedDescriptor() {
        String key = this.name().toLowerCase(Locale.ROOT);
        String prefix = "quest.reputation.status.";
        TranslationTextComponent textComponent = new TranslationTextComponent(prefix + key);
        textComponent.func_240701_a_(new TextFormatting[]{this.color, TextFormatting.BOLD});
        return textComponent;
    }
}

